<?php
/*
=====================================================
 File: text_skin.php
=====================================================
*/

function tpl_main ($tpl){
	
	global $config, $forum_config;

$textversion = <<<HTML
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset={$tpl['charset']}" />
	<link rel="stylesheet" rev="stylesheet" href="{$config['http_home_url']}/engine/forum/textscreen.css" media="screen" />
	<title>{$tpl['title']}</title>
</head>
<body>
<div id='wrapper'>
  <div id='largetext'>   : <a href='{$tpl['full_version_link']}'>{$tpl['full_version']}</a></div>
  <div class='nav'>{$tpl['nav']}</div>
  {$tpl['pages']}
  <div id='content'>
  {$tpl['content']}
  </div>
  {$tpl['pages']}
  <div class='smalltext'>     , , <a href='{$tpl['full_version_link']}'>  </a>.</div>
</div>
<div id='copyright'><a href='http://www.dle-files.ru/release/dle-forum/'>DLE Forum</a>  2009 <a href='http://www.dle-files.ru'>DLE Files Group</a></div>
</body>
</html>
HTML;

echo $textversion;

}

function tpl_forums_page ($forums)
{	
return <<<HTML
<div class='forumwrap'>
<ul>
$forums
</ul>
</div>	
HTML;
}

function tpl_forum_page ($topics)
{	
return <<<HTML
<div class='topicwrap'>
<ol>
$topics
</ol>
</div>	
HTML;
}

function tpl_pages ($cstart, $count_all, $inpage, $url)
{
	$pages_count = @ceil($count_all / $inpage);
	
	$pages_start_from = 0;
	$pages = "";
	
	for ($j=1; $j <= $pages_count; $j++)
	{
		if ($pages_start_from != $cstart)
		{
			$pages .= "<a href=\"{$url}-{$j}\">{$j}</a> ";
		}
		
		else
		{
			$pages .= " <b>{$j}</b> ";
		}
		
		$pages_start_from += $inpage;
	}
	
	return ("<div class='pagespan'><b>:</b> {$pages}</div>");
}

function tpl_category ($id, $name)
{
	return ("\n<li><strong><a href='?c{$id}'>{$name}</a></strong></li>\n<ul>");
}

function tpl_category_end ()
{
	return ("\n</ul></li>");
}

function tpl_forum ($id, $name, $post, $sub = false)
{
	if ($sub)
	{
		$sub_tpl = "\n<li><ul>{$sub}</ul></li>\n";
	}
	
	return ("\n<li><a href='?f{$id}'>{$name}</a> <span class='desc'>({$post} )</span></li>".$sub_tpl);
}

function tpl_forum_sub ($id, $name)
{
	return ("\n<li><a href='?f{$id}'>{$name}</a></li>");
}

function tpl_post ($post, $author, $date)
{
return <<<HTML
<div class='postwrapper'>
<div class='posttopbar'> 
  <div class='postname'>{$author}</div> 
  <div class='postdate'>{$date}</div> 
</div> 
 <div class='postcontent'>{$post}</div> 
</div>
HTML;
}

function tpl_topic_list ($id, $n_pre, $name, $post)
{
	return ("\n<li>{$n_pre}<a href='?t{$id}'>{$name}</a> <span class='desc'>({$post} )</span></li>");
}

?>